
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** calendar.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function patientId(){
	return noa().patient_id();
}

///// カルテからの継承値 ///
/////////////////////////


var _counter;
function setCounter(array){
    // "[...]" 印のあるページの受診日の配列
    _counter = array;
}
function counter(){
    return _counter;
}
function hasCouner(date){
    // _counter に date が含まれれば true を返す
    for (num in _counter){
        var entryDate = _counter[num];
        if (isSameDate(date, entryDate))
            return true;
    }
    return false;
}

function pageScrollUp(date){
    // ページを画面上端にスクロール
    var obj = noa().structure();
    for (entryDate in obj){
        if (isSameDate(date, entryDate)){
            noa().pageScrollTo(entryDate);
            return; // 受診歴があったのでそのページにスクロール
        }
    }
    
    // 受診歴がなかった：すなわち予約日
    for (num in _bookingArray){
        var entryDate = _bookingArray[num];
        if (isSameDate(date, entryDate)){
            // 予約年月日に一致した予約日時を得、そのページを追加
            if (confirm("予約日："+entryDate + " のページをカルテに追加しますか")){
                // ## 同じ年月日に２つ以上予約があった場合（それはないはずだが）最初のものをゲット
                noa().addPage(entryDate);
            }
        }
    }
}

function hideCount(date){
    // マウスで指した日付の count を消す
    var array = date.split("-");
    var year = array[0];
    var month = array[1];
    var day = array[2];
    
	var elm = document.getElementById("calMessage"+year+month);
    elm.innerHTML = "";
}
function showCount(date){
    // マウスで指した日付の count を表示
    var array = date.split("-");
    var year = array[0];
    var month = array[1];
    var day = array[2];
    
	var elm = document.getElementById("calMessage"+year+month);
    
    for (num in _counter){
        var entryDate = _counter[num];
        if (isSameDate(date, entryDate)){
            elm.innerHTML = _counter.length - num + " 回目";
            elm.style.paddingLeft = "10px";
        }
    }
}
function showMonth(year, month){
    // その月のカレンダーを表示
    var cal = document.getElementById(year + "_" + month + ".calendar");
    if (cal && cal.innerHTML.length){
        // すでにカレンダーが開いていれば閉じて終了
        cal.innerHTML = "";
        return;
    }
    
    var div = document.getElementById(year + "_" + month + ".bar");
    div.innerHTML = "";
    
    // div.innerHTML = "" を行うので、年月ラベルを再構築
    makeYearMonthLabel(div, year, month);
    
    // カレンダー本体
    var dv = newDIV(div, year + "_" + month + ".calendar");
    dv.setAttribute("class", "calTableArea");
    
    var tbl = newTABLE(dv, "calendarTable");
    
    // WEEK
    var tr = newTR(tbl, "", "");
    var array = weeks(); // lib.js
    for (num in array){
        var td = newTD(tr, "", array[num]);
        td.style.textAlign = "right";
        td.style.padding = "0px 5px";
    }
    
    // DAY
    var lastDay = getLastDate(year, month);
    var w = 0;
    
    if (calendarIsReverse() > 0){
        // 毎月のカレンダーを逆順に表示
        var lastWeek = weekOfDate(year + "-" + month + "-" + lastDay);
        var lastW = lastW(lastWeek);
        var day = lastDay * 1 - lastW * 1;
        var weekBeginDay = day; // 週開始の日付
        
        while (day > -7){
            if (w == 0)
                var tr = newTR(tbl, "", "");
            
            if (day > lastDay){
                var td = newTD(tr, "/dateTip", ""); // 空欄日付を表示
            } else if (day <= 0){
                var td = newTD(tr, "/dateTip", ""); // 空欄日付を表示
                day++;
            } else {
                var td = newTD(tr, "/dateTip", "" + day);
                var dd = (day * 1 < 10) ? "0" + day : day;
                var date = year + "-" + month + "-" + dd;
                td.setAttribute("onclick", "pageScrollUp('" + date + "')");
                day++;
            }
            
            if (isVisitDate(date)){ // 受診した日付
                if (td.innerHTML.length == 0){
                    // do nothing
                } else if (hasCouner(date)){
                    // subject に "[...]" 形式のマークが存在
                    td.setAttribute("class", "yellowDateTip");
                    td.setAttribute("onmouseover", "showCount('" + date + "')");
                    td.setAttribute("onmouseout", "hideCount('" + date + "')");
                } else {
                    td.setAttribute("class", "greenDateTip");
                }
            } else if (isBookingDate(date)){
                td.setAttribute("class", "pinkDateTip");
            }
            
            if (++w == 7){
                if (day <= 8) break;
                
                w = 0;
                day = weekBeginDay - 7;
                weekBeginDay = day;
            }
        }
    } else {
        var firstWeek = weekOfDate(year + "-" + month + "-01");
        var day = 0;

        while (day <= lastDay){
            if (w == 0)
                var tr = newTR(tbl, "", "");
            
            if (day == 0){
                if (firstWeek == weeks()[w]){
                    // 曜日が月初の曜日と一致したなら１日に設定
                    day = 1;
                } else {
                    // そうでなければ空欄日付を表示
                    w++;
                    var td = newTD(tr, "/dateTip", "");
                    continue;
                }
            }
            var st = (day > 0) ? "" + day : "";
            
            var td = newTD(tr, "/dateTip", st);
            var dd = (day * 1 < 10) ? "0" + day : day;
            var date = year + "-" + month + "-" + dd;
            td.setAttribute("onclick", "pageScrollUp('" + date + "')");
            
            if (isVisitDate(date)){ // 受診した日付
                if (hasCouner(date)){
                    // subject に "[...]" 形式のマークが存在
                    td.setAttribute("class", "yellowDateTip");
                    td.setAttribute("onmouseover", "showCount('" + date + "')");
                    td.setAttribute("onmouseout", "hideCount('" + date + "')");
                } else {
                    td.setAttribute("class", "greenDateTip");
                }
            } else if (isBookingDate(date)){
                td.setAttribute("class", "pinkDateTip");
            }
            
            day++;
            if (day > lastDay) break;
            if (++w > 6) w = 0;
        }
    }
    
    // keyCount モードのカウント数を表示するエリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "calMessage"+year+month, "");
	td.setAttribute("colspan", "7");
	td.style.color = "#00f"; //blue
    
    function isVisitDate(date){
        // year, month, day が受診日なら true を返す
        var obj = noa().structure();
        for (entryDate in obj){
            if (isSameDate(date, entryDate)) return true;
        }
        return false;
    }
    function isBookingDate(date){
        // year, month, day が予約日なら true を返す
        for (num in _bookingArray){
            var entryDate = _bookingArray[num];
            if (isSameDate(date, entryDate)) return true;
        }
        return false;
    }
    
    function lastW(weekSt){
        // 曜日に対応する数値を返す
        var array = weeks();
        for (num in array){
            if (array[num] == weekSt)
                return num;
        }
        return 0;
    }
}

function makeYearMonthLabel(div, year, month){
    // 年月 ラベル
    var dv = newDIV(div, "/yearMonthLabel");
    dv.innerHTML = year + "・" + month;
    dv.setAttribute("onclick", "showMonth('"+year+"','"+month+"')");
}

function showMonthlyCalendar(){
    // 各月のカレンダーを表示
	var elm = document.getElementById("contentsArea");
	elm.innerHTML = "";
    
    var calbg = newDIV(elm, ""); // カレンダー背景
    
    // structure() から受診日の配列を生成
    var dateArray = new Array();
    var obj = noa().structure();
    for (entryDate in obj){
        dateArray.push(entryDate);
    }
    
    // 予約日があればそれをマージ
    if (_bookingArray){
        dateArray = _bookingArray.concat(dateArray);
    }
    
    if (calendarIsReverse() == 0){
        // 正順にソート
        dateArray = dateArray.reverse();
    }
    
    var year;
    var month;
    for (num in dateArray){
        // rec は ProgressSection と NameSection のデータを保有
        var entryDate = dateArray[num];
        var st = entryDate.substr(0,10);
        var ary = st.split("-");
        
        if ((year != ary[0]) || (month != ary[1])){
            year = ary[0];
            month = ary[1];
            var div = newDIV(calbg, year + "_" + month + ".bar");
            div.setAttribute("class", "yearMonthRow");
            
            // 年月 ラベル
            makeYearMonthLabel(div, year, month); // float:left
 
            // _expandMode か 参照中の受診日と同月なら カレンダーを開く
            if (_expandMode || (isSameMonth(entryDate, noa().currentDate()))){
               showMonth(year, month);
            }
        }
    }
}

var _bookingArray;
function gotBooking(answer){
    // 予約日リストが answer として返される
    //alert("gotBooking->"+answer); //##
    _bookingArray = JSON.parse(answer);
    //alert("records->"+encodeObject(array)); //##
    
    // 各月のカレンダーを表示
    showMonthlyCalendar();
}

function getCounter(){
    // [candida治療] などの印のついた受診日の配列を返す
    var counter = new Array();
    var obj = noa().structure();
    var key;
    var hasBegin;
    for (entryDate in obj){
        var fields = obj[entryDate];
        var rec = fields['ProgressSection.subject'];
        var val = rec.trimValue; // 主訴欄の value
        
        if (val.length == 0) continue;
        if (! hasCountForm(val)) continue;
        
        // "[..." を key にする
        if (!key) key = getCountKey(val);
        
        // key が val に含まれれば配列に追加処理
        if (val.indexOf(key) >= 0){
            // 起点を見つけた以後 ":開始]" なくなれば配列生成終了
            if (hasBegin && (val.indexOf(":開始]") < 0))
                return counter;
            
            // key がみつかるごと配列に記憶
            counter.push(entryDate);
            
            // "[...:終了]" があれば、そこまでの配列は消去
            if (val.indexOf(":終了]") >= 0){
                counter = new Array();
                counter.push(entryDate);
            }
            
            // "[...:開始]" があれば起点とする
            if (val.indexOf(":開始]") >= 0)
                hasBegin = true;
        }
    }
    return counter;
    
    function hasCountForm(buff){
        // buff に "[...]" が含まれれば true を返す
        if (buff.indexOf("[") < 0) return false;
        if (buff.indexOf("]") < 0) return false;
        return true;
    }
    
    function getCountKey(buff){
        // buff 中の "[..." を key として返す
        var array = buff.split("[");
        var st = array[1];
        array = st.split("]");
        st = array[0];
        array = st.split(":");
        
        return "[" + array[0];
    }
}

function checkReverse(elm){
    // 逆順チェック・ボックスがチェックされた
    setCalendarIsReverse(elm);
    initCalendar();
}
function showPreference(){
    // 初期設定を表示
    var elm = document.getElementById("prefArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    
    var cb = newCHECKBOX(elm, "", "逆順に表示", calendarIsReverse());
    cb.setAttribute("onchange", "checkReverse(this)");
}

var _expandMode;
function expandCalendar(){
    // problemList を展開する
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.setAttribute("onclick", "foldCalendar()");
    elm.style.padding = "0 2px 5px 2px";
	var img = newIMAGE(elm, "", "./arrowDown.png", "?");
	img.style.height = "15px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "4px";
    _expandMode = (_expandMode) ? false : true;
    showMonthlyCalendar();
    
    var label = document.getElementById("calLabel");
    label.style.position = "relative";
    label.style.top = "2px";
}
function foldCalendar(){
    // problemList を折畳む
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.style.padding = "0 0";
    elm.style.position = "relative";
    elm.style.bottom = "-2px";
    elm.setAttribute("onclick", "expandCalendar()");
	var img = newIMAGE(elm, "", "./arrowLeft.png", "?");
	img.style.height = "8px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "4px";
    _expandMode = (_expandMode) ? false : true;
    showMonthlyCalendar();
    
    var label = document.getElementById("calLabel");
    label.style.position = "relative";
    label.style.top = "6px";
}

function calendarHelp(){
    // HELP を開く
	// 別途ヘルプをパネル表示
	window.open("./calendarHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initCalendar(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    elm.style.backgroundColor = "#cfe";
    
    // HEADER
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ------------
    var dv = newDIV(div, "/left-side");
    // ARROW ICON
    var sp = newDIV(dv, "arrowArea");
    sp.style.display = "inline";
    sp.setAttribute("onclick", "expandCalendar()");
	var img = newIMAGE(sp, "", "./arrowLeft.png", "?");
	img.style.height = "8px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "7px";
    // TITLE
    var sp = newSPAN(dv, "calLabel/titleLabel");
    sp.innerHTML = "CALENDAR";
    sp.style.position = "relative";
    sp.style.top = "5px";
    // --- RIGHT SIDE ----------
    var dv = newDIV(div, "/right-side2");
    var img = newIMAGE(dv, "", "Help.png", "icon");
    img.style.height = "19px";
    img.style.position = "relative";
    img.style.top = "3px";
    img.setAttribute("onclick", "calendarHelp()");
    
    // CONTENTS
    var dv = newDIV(elm, "contentsArea");
    
    // FOOTER
    var div = newDIV(elm, "tool-footer");
    var dv = newDIV(div, "left-side");
	var img = newIMAGE(dv, "", "./hammer.png", "?");
	img.style.height = "14px";
	img.setAttribute("onclick", "showPreference()"); //###
    var sp = newSPAN(dv, "prefArea");
    sp.style.paddingLeft = "5px";
    var dv = newDIV(div, "right-side");
    dv.innerHTML = version();
    dv.style.position = "relative";
    dv.style.top = "2px";
    
    // [candida治療] などの印をカウントし配列に記憶
    setCounter(getCounter());
    
    // ### FrontTable の本日以後から、この patientId の予約年月日をスキャン
    // ### そのリストを得た上で showMonthlyCalendar() を実行
    NRGetBooking(patientId(), noa().currentDate(), gotBooking);
}

function version(){
    return "Ver.121129";
}

